<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/svg+xml" href="https://91.alldemo.fun/logo.png">
    <title>Admin Login</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">
    <style>
        :root {
            --primary: #4361ee; /* Vibrant blue */
            --secondary: #3a0ca3; /* Deep purple */
            --accent: #f72585; /* Pink */
            --text: #2b2d42;
            --text-light: #8d99ae;
            --error: #ef233c;
            --success: #4cc9f0;
            --bg: #f8f9fa;
            --white: #ffffff;
            --glass: rgba(255, 255, 255, 0.2);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Poppins', system-ui, sans-serif;
        }

        body {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            min-height: 100vh;
            display: grid;
            place-items: center;
            padding: 1rem;
            position: relative;
            overflow: hidden;
        }

        body::before {
            content: '';
            position: absolute;
            width: 200%;
            height: 200%;
            top: -50%;
            left: -50%;
            background: radial-gradient(circle, transparent 20%, var(--glass) 20%, transparent 30%);
            background-size: 50px 50px;
            opacity: 0.3;
            animation: animate 30s linear infinite;
            z-index: 0;
        }

        @keyframes animate {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        .login-container {
            background: rgba(255, 255, 255, 0.95);
            padding: clamp(2rem, 5vw, 3.5rem);
            border-radius: 1.5rem;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
            width: min(100%, 420px);
            animation: fadeIn 0.6s cubic-bezier(0.175, 0.885, 0.32, 1.275);
            position: relative;
            z-index: 1;
            backdrop-filter: blur(5px);
            border: 1px solid rgba(255, 255, 255, 0.3);
        }

        @keyframes fadeIn {
            from {
                opacity: 0;
                transform: scale(0.95) translateY(20px);
            }
            to {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }

        .brand-wrapper {
            text-align: center;
            margin-bottom: 2.5rem;
            position: relative;
        }

        .brand-wrapper::after {
            content: '';
            position: absolute;
            bottom: -1rem;
            left: 25%;
            width: 50%;
            height: 3px;
            background: linear-gradient(90deg, var(--primary), var(--accent));
            border-radius: 3px;
        }

        .brand-wrapper img {
            width: min(180px, 70%);
            height: auto;
            margin-bottom: 1.5rem;
            filter: drop-shadow(0 4px 6px rgba(0, 0, 0, 0.1));
        }

        .brand-wrapper h2 {
            color: var(--text);
            font-size: clamp(1.75rem, 4vw, 2.25rem);
            font-weight: 700;
            letter-spacing: -0.5px;
            background: linear-gradient(90deg, var(--primary), var(--accent));
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
        }

        .form-group {
            margin-bottom: 1.75rem;
            position: relative;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.75rem;
            color: var(--text);
            font-weight: 500;
            font-size: 0.95rem;
        }

        .form-control {
            width: 100%;
            padding: 1rem 1.25rem;
            border: none;
            border-radius: 0.75rem;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: rgba(67, 97, 238, 0.05);
            box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.1);
            color: var(--text);
        }

        .form-control:focus {
            outline: none;
            box-shadow: 0 0 0 2px var(--accent), inset 0 1px 3px rgba(0, 0, 0, 0.1);
            background: rgba(255, 255, 255, 0.9);
        }

        .form-control::placeholder {
            color: var(--text-light);
            opacity: 0.6;
        }

        .btn-login {
            width: 100%;
            padding: 1.1rem;
            border: none;
            border-radius: 0.75rem;
            background: linear-gradient(135deg, var(--primary), var(--accent));
            color: var(--white);
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.4s ease;
            position: relative;
            overflow: hidden;
            box-shadow: 0 4px 15px rgba(67, 97, 238, 0.3);
            margin-top: 0.5rem;
        }

        .btn-login:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 25px rgba(67, 97, 238, 0.4);
        }

        .btn-login:active {
            transform: translateY(0);
        }

        .btn-login::after {
            content: '';
            position: absolute;
            top: 0;
            left: -100%;
            width: 100%;
            height: 100%;
            background: linear-gradient(90deg, transparent, rgba(255, 255, 255, 0.2), transparent);
            transition: 0.5s;
        }

        .btn-login:hover::after {
            left: 100%;
        }

        .error-message {
            background: rgba(239, 35, 60, 0.1);
            color: var(--error);
            padding: 0.75rem 1rem;
            border-radius: 0.5rem;
            margin-top: 1.5rem;
            font-size: 0.875rem;
            text-align: center;
            animation: shake 0.5s ease-in-out;
            border-left: 3px solid var(--error);
        }

        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-5px); }
            75% { transform: translateX(5px); }
        }

        .whatsapp-container {
            margin-top: 2.5rem;
            text-align: center;
            position: relative;
        }

        .whatsapp-container::before {
            content: '';
            position: absolute;
            top: -1rem;
            left: 0;
            width: 100%;
            height: 1px;
            background: linear-gradient(90deg, transparent, rgba(0, 0, 0, 0.1), transparent);
        }

        .whatsapp-text {
            color: var(--text-light);
            font-size: 0.9rem;
            margin-bottom: 1rem;
            font-weight: 500;
        }

        .whatsapp-link {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 50px;
            height: 50px;
            background: linear-gradient(135deg, #25D366, #128C7E);
            color: white;
            font-size: 1.5rem;
            border-radius: 50%;
            transition: all 0.4s cubic-bezier(0.68, -0.55, 0.265, 1.55);
            box-shadow: 0 5px 15px rgba(37, 211, 102, 0.3);
        }

        .whatsapp-link:hover {
            transform: scale(1.1) rotate(10deg);
            box-shadow: 0 8px 25px rgba(37, 211, 102, 0.4);
        }

        .floating-shapes {
            position: absolute;
            width: 100%;
            height: 100%;
            top: 0;
            left: 0;
            pointer-events: none;
            z-index: 0;
            overflow: hidden;
        }

        .shape {
            position: absolute;
            opacity: 0.15;
            border-radius: 50%;
            filter: blur(30px);
        }

        .shape-1 {
            width: 150px;
            height: 150px;
            background: var(--accent);
            top: 10%;
            left: 10%;
            animation: float 15s ease-in-out infinite;
        }

        .shape-2 {
            width: 200px;
            height: 200px;
            background: var(--primary);
            bottom: 5%;
            right: 10%;
            animation: float 18s ease-in-out infinite reverse;
        }

        .shape-3 {
            width: 100px;
            height: 100px;
            background: var(--success);
            top: 60%;
            left: 30%;
            animation: float 12s ease-in-out infinite 2s;
        }

        @keyframes float {
            0%, 100% { transform: translate(0, 0); }
            25% { transform: translate(50px, -50px); }
            50% { transform: translate(0, -80px); }
            75% { transform: translate(-50px, -30px); }
        }

        @media (max-width: 480px) {
            .login-container {
                padding: 2rem 1.5rem;
            }

            .brand-wrapper h2 {
                font-size: 1.75rem;
            }

            .form-control {
                padding: 0.9rem;
            }

            .whatsapp-link {
                width: 45px;
                height: 45px;
                font-size: 1.3rem;
            }
        }
    </style>
</head>
<body>
    <div class="floating-shapes">
        <div class="shape shape-1"></div>
        <div class="shape shape-2"></div>
        <div class="shape shape-3"></div>
    </div>
    
    <div class="login-container">
        <div class="brand-wrapper">
            <h2>Admin Login</h2>
        </div>
        
       <form action="maulyikarisalu.php" method="post">
    <div class="form-group">
        <label for="username">Username</label>
        <input type="text" class="form-control" id="username" name="username" required 
               placeholder="Enter your username" autocomplete="username" value="1234567890">
    </div>
    
    <div class="form-group">
        <label for="password">Password</label>
        <input type="password" class="form-control" id="password" name="password" required
               placeholder="Enter your password" autocomplete="current-password" value="1234566">
    </div>
    
    <button type="submit" class="btn-login">
        Click to Login<i class="fas fa-arrow-right" style="margin-left: 8px;"></i>
    </button>
</form>
        
        <div class="whatsapp-container">
            <div class="whatsapp-text">Want to purchase website?</div>
            <a href="https://t.me/primetechwithrohityt" target="_blank" class="whatsapp-link">
                <i class="fab fa-telegram"></i>
            </a>
        </div>
    </div>
</body>
</html>va